/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ShwConfig {
    public final ForgeConfigSpec.BooleanValue isDimensionalTravelAllowedForHome;
    public final ForgeConfigSpec.IntValue homeCooldown;
    public final ForgeConfigSpec.BooleanValue isDimensionalTravelAllowedForWaypoints;
    public final ForgeConfigSpec.IntValue waypointsCooldown;
    public final ForgeConfigSpec.IntValue maxNbOfWaypoints;

    public ShwConfig(ForgeConfigSpec.Builder builder) {
        this.isDimensionalTravelAllowedForHome = builder.comment("Is dimensional travel allowed for home command").translation("shw.config.home.dimensionalTravel").define("shw_is_dimensional_travel_allowed_for_home", true);
        this.homeCooldown = builder.comment("Cooldown in second before home command can be reused").translation("shw.config.home.cooldown").defineInRange("shw_home_cooldown", 10, 0, Integer.MAX_VALUE);
        this.isDimensionalTravelAllowedForWaypoints = builder.comment("Is dimensional travel allowed for waypoints command").translation("shw.config.waypoints.dimensionalTravel").define("shw_is_dimensional_travel_allowed_for_waypoints", true);
        this.waypointsCooldown = builder.comment("Cooldown in second before waypoint command can be reused").translation("shw.config.waypoints.cooldown").defineInRange("shw_waypoints_cooldown", 10, 0, Integer.MAX_VALUE);
        this.maxNbOfWaypoints = builder.comment("Maximum number of waypoints by player").translation("shw.config.waypoints.maximumNumberOfWaypoints").defineInRange("shw_maximum_number_of_waypoints", 10, 0, 100);
    }
}

